<?php

/*
 * ==========================================================
 * WHMCS APP MODULE FOR SUPPORT BOARD
 * ==========================================================
 *
 * WHMCS App Module.  2017-2022 board.support. All rights reserved.
 *
 */

use WHMCS\Database\Capsule;
use WHMCS\Module\Addon\AddonModule\Admin\AdminDispatcher;
use WHMCS\Module\Addon\AddonModule\Client\ClientDispatcher;

if (!defined('WHMCS')) {
    die('This file cannot be accessed directly');
}

function supportboard_config() {
    return [
        'version' => '1.0.0',
        'name' => 'Support Board',
        'description' => ' WHMCS App Module for Support Board. Allow your clients to connect with you via chat and tickets in real-time.',
        'author' => 'Schiocco',
        'language' => 'english',
        'fields' => [
            'sb_whmcs_url' => [
                'FriendlyName' => 'Support Board Plugin URL',
                'Type' => 'text',
                'Size' => '25',
                'Description' => 'Insert the URL of the Support Board installation directory or the admin link. Ex. https://www.your-site.com/supportboard.',
            ],
            'sb_whmcs_visibility' => [
                'FriendlyName' => 'Chat visiblity',
                'Type' => 'dropdown',
                'Options' => [
                    'all' => 'All users',
                    'login' => 'Logged-in users only'
                ],
                'Description' => 'Initialize and display the chat widget for all users, or only when the user is logged in.',
            ],
            'sb_admin_type' => [
                'FriendlyName' => 'Support Board Admin Area',
                'Type' => 'dropdown',
                'Options' => [
                    'new-window' => 'New window',
                    'inside' => 'Inside WHMCS'
                ],
                'Description' => 'Set where to open the Support Board admin panel.',
            ],
            'sb_whmcs_path' => [
                'FriendlyName' => 'Support Board Path',
                'Type' => 'text',
                'Size' => '25',
                'Description' => 'Required if the Support Board admin panel opens inside WHMCS. Get it from Support Board > Settings > Miscellaneous > Support Board Path.',
            ],
            'sb_whmcs_users_department' => [
                'FriendlyName' => 'Logged-in Users Department',
                'Type' => 'text',
                'Size' => '25',
                'Description' => 'Automatically assigns a department to logged-in users. Insert here the department ID. Get the ID from Support Board > Settings > Miscellaneous > Departments.',
            ],
            'sb_whmcs_visitors_department' => [
                'FriendlyName' => 'Visitors Department',
                'Type' => 'text',
                'Size' => '25',
                'Description' => 'Automatically assigns a department to visitors. Insert here the department ID. Get the ID from Support Board > Settings > Miscellaneous > Departments.',
            ],
            'sb_whmcs_button_tickets' => [
                'FriendlyName' => 'Tickets Area Button Name',
                'Type' => 'text',
                'Size' => '25',
                'Description' => 'Insert the name of the tickets menu that will appear in the client area. The link will open the Support Board Tickets area. This feature requires the Tickets App (https://board.support/tickets). Leave empty to disable.',
            ]
        ]
    ];
}

/*
 * ----------------------------------------------------------
 * ADMIN AREA
 * ----------------------------------------------------------
 *
 */

function supportboard_output($vars) {
    if (!empty($vars['sb_admin_type']) && $vars['sb_admin_type'] == 'inside') {
        $SB_PATH = $vars['sb_whmcs_path'];
        if (empty($SB_PATH)) {
            echo 'Please insert the Support Board Path in Configuration > System Settings > Addon Modules > Support Board. Get it from Support Board > Settings > Miscellaneous > Support Board Path.';
            return;
        }
        if (!file_exists($SB_PATH . '/include/functions.php')) {
            $path = dirname(__DIR__);
            $text = 'Your Support Board Path is not correct. Get it from Support Board > Settings > Miscellaneous > Support Board Path.';
            if (strpos($path, '/admin')) {
                $path = substr($path, 0, strpos($path, '/admin'));
                $text .= ' Example: ' . $path . 'supportboard';
            }
            echo $text;
            return;
        }
        require_once($SB_PATH . '/include/functions.php');
        require_once($SB_PATH . '/include/components.php');
        echo '<script src="' . SB_URL . '/js/main.js?v=' . SB_VERSION .'"></script><script src="' . SB_URL . '/js/admin.js?v=' . SB_VERSION .'"></script><link rel="stylesheet" href="'. SB_URL . '/css/admin.css?v=' . SB_VERSION . '"><link rel="stylesheet" href="'. SB_URL . '/apps/whmcs/admin.css?v=' . SB_VERSION . '">';
        sb_set_external_active_admin(empty($_SESSION['adminid']) ? false : sb_whmcs_get_admin($_SESSION['adminid']));
        sb_js_global();
        sb_js_admin();
        sb_component_admin();
    }
}

/*
 * ----------------------------------------------------------
 * CLIENT AREA
 * ----------------------------------------------------------
 *
 */

function supportboard_clientarea($vars) {
    return array(
        'pagetitle' => 'Tickets',
        'breadcrumb' => array('index.php?m=supportboard' => 'Tickets'),
        'templatefile' => 'tickets',
        'requirelogin' => true,
        'forcessl' => false
    );
}

?>