<?php

/*
 * ==========================================================
 * WHMCS APP MODULE - HOOKS
 * ==========================================================
 *
 * WHMCS App Module.  2017-2022 board.support. All rights reserved.
 *
 */

use WHMCS\View\Menu\Item as MenuItem;

function sb_whmcs_get_settings() {
    $settings = [];
    $sql = select_query('tbladdonmodules', 'setting,value', array('module' => 'supportboard'));
    while ($data = mysql_fetch_array($sql)) {
        $settings[$data['setting']] = $data['value'];
    }
    return $settings;
}

add_hook('AdminAreaFooterOutput', 1, function($vars) {
    $settings = sb_whmcs_get_settings();
    if ((empty($settings) || empty($settings['sb_admin_type']) || $settings['sb_admin_type'] == 'new-window') && !empty($settings['sb_whmcs_url'])) {
        return '<script type="text/javascript">(function ($) { $(document).ready(function () { $("[id=\'Menu-Addons-Support Board\']").attr("href", "' . str_replace('/admin.php', '', $settings['sb_whmcs_url']) . '/admin.php").attr("target", "_blank") })}(jQuery))</script>';
    }
});

add_hook('ClientAreaFooterOutput', 1, function($vars) {
    $settings = sb_whmcs_get_settings();
    $script = '';
    if ((empty($settings) || empty($settings['sb_whmcs_visibility']) || $settings['sb_whmcs_visibility'] == 'all') || isset($_SESSION['login_auth_tk'])) {
        if (isset($_SESSION['login_auth_tk'])) {
            $data = json_decode($_SESSION['login_auth_tk'], true);
            $script = 'var SB_WHMCS_ACTIVE_USER = "' . $data['id'] . '";';
            if (!empty($settings['sb_whmcs_users_department'])) {
                $script .= 'var SB_DEFAULT_DEPARTMENT = "' . $settings['sb_whmcs_users_department'] . '";';
            }
        } else {
            if (!empty($settings['sb_whmcs_visitors_department'])) {
                $script .= 'var SB_DEFAULT_DEPARTMENT = "' . $settings['sb_whmcs_visitors_department'] . '";';
            }
        }
        return '<script src="' . str_replace('/admin.php', '', $settings['sb_whmcs_url']) . '/js/main.js" id="sbinit"></script>' . ($script == '' ? '' : ('<script>' . $script . '</script>'));
    }
    return '';
});

add_hook('ClientAreaPrimaryNavbar', 1, function (MenuItem $primaryNavbar) {
    $button = select_query('tbladdonmodules', 'setting,value', array('module' => 'supportboard', 'setting' => 'sb_whmcs_button_tickets'));
    $button = mysql_fetch_assoc($button);
    if (!empty($button) && !empty($button['value'])) {
        $primaryNavbar->addChild($button['value'])->setUri('?m=supportboard')->setOrder(70);
    }
});

?>